/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.valores.ModeloValoresCliente;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Comprador;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Venta;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class DialogoCliente
extends DialogoBase
implements VistaModelo<Comprador>,
VistaValoresPropios {
    private static final String EL_CLIENTE_YA_SE_ENCUENTRA_REGISTRADO = "El cliente ya se encuentra registrado";
    private DataBindingContext m_bindingContext;
    private ModeloValoresCliente modeloCliente;
    private Comprador modeloDatos;
    private Text txtIdentificacion;
    private ComboViewer cvTipoID;
    private Composite panelRelacionada;
    private boolean editando;
    private Comprador clienteActual = new Comprador();
    private List<Venta> clientesExistentes;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private Button button;
    private Button button_1;
    private ComboViewer cvTipoCliente;
    private Text txtRazonSocial;
    private Label lblRazonSocial;
    private Label lblTipoDeCliente;
    private Combo cmbTipoCliente;

    protected Point getInitialSize() {
        return new Point(480, 420);
    }

    public DialogoCliente(IWorkbenchPartSite site, List<Venta> clientesExistentes, boolean editando) {
        super(site);
        this.setShellStyle(80);
        this.editando = editando;
        this.clientesExistentes = clientesExistentes;
    }

    public void inicializarModeloValores() {
        this.modeloCliente = new ModeloValoresCliente();
        this.modeloCliente.inicializar();
    }

    public void setModeloDatos(Comprador modeloDatos) {
        this.modeloDatos = modeloDatos;
        if (this.editando) {
            this.clienteActual.setIdentificacion(modeloDatos.getIdentificacion());
            this.clienteActual.setTipoIdentificacion(modeloDatos.getTipoIdentificacion());
        }
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    public void procesarModeloDatos() {
        String codigoTipoId = this.modeloDatos.getTipoIdentificacion();
        ElementoNombreValor<String> tipoIdentificacion = this.seleccionarTipoIdentificacionEnCombo(codigoTipoId);
        if (codigoTipoId != null && !((String)tipoIdentificacion.getValor()).equals("F")) {
            this.txtIdentificacion.setEditable(true);
        } else {
            this.panelRelacionada.setVisible(false);
        }
        this.seleccionarTipoDeCliente(this.modeloDatos.getTipoProveedor());
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                if (!DialogoCliente.this.modeloDatos.equals((Object)DialogoCliente.this.clienteActual)) {
                    Venta cTemp = new Venta();
                    cTemp.setComprador(DialogoCliente.this.modeloDatos);
                    if (DialogoCliente.this.clientesExistentes.contains(cTemp)) {
                        resultado.fallarValidacion(DialogoCliente.EL_CLIENTE_YA_SE_ENCUENTRA_REGISTRADO);
                    }
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    private ElementoNombreValor<String> seleccionarTipoIdentificacionEnCombo(String codigoTipoId) {
        ElementoNombreValor tipoIdentificacion = this.modeloCliente.obtenerTipoIdentificacion(codigoTipoId);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoID, (Object)tipoIdentificacion);
        return tipoIdentificacion;
    }

    private void seleccionarTipoDeCliente(String tipoCliente) {
        ElementoNombreValor tipoDeCliente = this.modeloCliente.obtenerClaseDeContribuyente(tipoCliente);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoCliente, (Object)tipoDeCliente);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Cliente Ventas");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.verticalSpacing = 3;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.heightHint = 168;
        gd_container.verticalAlignment = 128;
        gd_container.horizontalAlignment = 16384;
        container.setLayoutData((Object)gd_container);
        Label lblTipoIdentificacin = new Label(container, 0);
        lblTipoIdentificacin.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTipoIdentificacin.setText("Tipo Identificaci\u00f3n:");
        this.cvTipoID = new ComboViewer(container, 8);
        this.manejarSeleccionComboTipoIdProveedor();
        Combo cmbTipoID = this.cvTipoID.getCombo();
        GridData gd_cmbTipoID = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_cmbTipoID.widthHint = 325;
        cmbTipoID.setLayoutData((Object)gd_cmbTipoID);
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setText("Identificaci\u00f3n:");
        this.txtIdentificacion = new Text(container, 2048);
        GridData gd_txtIdentificacion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtIdentificacion.widthHint = 188;
        this.txtIdentificacion.setLayoutData((Object)gd_txtIdentificacion);
        this.txtIdentificacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoCliente.this.txtIdentificacion.selectAll();
            }
        });
        this.txtIdentificacion.setTextLimit(13);
        this.panelRelacionada = new Composite(container, 0);
        this.panelRelacionada.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gd_panelRelacionada = new GridLayout(2, false);
        gd_panelRelacionada.marginWidth = 0;
        this.panelRelacionada.setLayout((Layout)gd_panelRelacionada);
        Label label = new Label(this.panelRelacionada, 0);
        label.setText("Es parte relacionada");
        Composite composite = new Composite(this.panelRelacionada, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.button = new Button(composite, 16);
        this.button.setText("SI");
        this.button_1 = new Button(composite, 16);
        this.button_1.setText("NO");
        this.lblTipoDeCliente = new Label(container, 0);
        this.lblTipoDeCliente.setText("Tipo de Cliente:");
        this.lblTipoDeCliente.setVisible(false);
        this.cvTipoCliente = new ComboViewer(container, 8);
        this.manejarSeleccionTipoCliente();
        this.cmbTipoCliente = this.cvTipoCliente.getCombo();
        this.cmbTipoCliente.setVisible(false);
        GridData gd_cmbTipoCliente = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbTipoCliente.widthHint = 325;
        this.cmbTipoCliente.setLayoutData((Object)gd_cmbTipoCliente);
        this.lblRazonSocial = new Label(container, 0);
        this.lblRazonSocial.setText("Raz\u00f3n Social:");
        this.lblRazonSocial.setVisible(false);
        this.txtRazonSocial = new Text(container, 2050);
        this.txtRazonSocial.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        this.txtRazonSocial.setTextLimit(500);
        this.txtRazonSocial.setVisible(false);
        this.txtRazonSocial.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return super.createDialogArea(parent);
    }

    private void manejarSeleccionTipoCliente() {
        this.cvTipoCliente.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor claseContribuyente = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (claseContribuyente != null) {
                    DialogoCliente.this.modeloDatos.setTipoProveedor((String)claseContribuyente.getValor());
                    DialogoCliente.this.modeloDatos.setDescripcionTipoProveedor(claseContribuyente.getNombre());
                }
            }
        });
    }

    public void manejarSeleccionComboTipoIdProveedor() {
        this.cvTipoID.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoIdentificacion = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoIdentificacion != null) {
                    DialogoCliente.this.modeloDatos.setTipoIdentificacion((String)tipoIdentificacion.getValor());
                    DialogoCliente.this.modeloDatos.setDescripcionTipoIdentificacion(tipoIdentificacion.getNombre());
                    DialogoCliente.this.mostrarParteRelacionadaDesdeMarzo2015((ElementoNombreValor<String>)tipoIdentificacion);
                    DialogoCliente.this.mostrarTipoDeClienteYRazonSocialDesdeMayo2016((ElementoNombreValor<String>)tipoIdentificacion);
                    if (((String)tipoIdentificacion.getValor()).equals("F")) {
                        DialogoCliente.this.txtIdentificacion.setText("9999999999999");
                        DialogoCliente.this.txtIdentificacion.setEditable(false);
                    } else {
                        if (DialogoCliente.this.txtIdentificacion.getText().equals("9999999999999")) {
                            DialogoCliente.this.txtIdentificacion.setText("");
                        }
                        DialogoCliente.this.txtIdentificacion.setEditable(true);
                        boolean esPasaporte = "P".equals(tipoIdentificacion.getValor());
                        DialogoCliente.this.renderizarRazonSocialParaAnexosDesdeMayo2016(esPasaporte);
                    }
                }
            }
        });
    }

    private void mostrarTipoDeClienteYRazonSocialDesdeMayo2016(ElementoNombreValor<String> tipoIdentificacion) {
        boolean esPasaporteYPeriodoDesdeMayo2016 = "P".equals(tipoIdentificacion.getValor()) && ((Iva)this.modeloDatos.getRaizModelo()).periodo.isAnexoEnPeriodoDesdeMayo2016();
        this.lblRazonSocial.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.txtRazonSocial.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.lblTipoDeCliente.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.cmbTipoCliente.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        if (!esPasaporteYPeriodoDesdeMayo2016) {
            this.txtRazonSocial.setText("");
        }
    }

    private void mostrarParteRelacionadaDesdeMarzo2015(ElementoNombreValor<String> tipoID) {
        boolean noEsConsumidorFinalOPlaca = !"F".equals(tipoID.getValor()) && !"L".equals(tipoID.getValor());
        this.panelRelacionada.setVisible(((Iva)this.modeloDatos.getRaizModelo()).periodo.isPeriodoDeAnexoDesdeMarzo2015() && noEsConsumidorFinalOPlaca);
    }

    private void renderizarRazonSocialParaAnexosDesdeMayo2016(boolean esPasaporte) {
        if (((Iva)this.modeloDatos.getRaizModelo()).periodo.isAnexoEnPeriodoDesdeMayo2016() && !esPasaporte) {
            this.txtRazonSocial.setText("");
            this.modeloDatos.setTipoProveedor(null);
            this.modeloDatos.setDescripcionTipoProveedor("");
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoID.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoID.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposIdentificacionClienteModeloClienteObserveList = PojoProperties.list((String)"tiposIdentificacionCliente").observe((Object)this.modeloCliente);
        this.cvTipoID.setInput((Object)tiposIdentificacionClienteModeloClienteObserveList);
        ISWTObservableValue observeTextTxtIdentificacionObserveWidget = SWTObservables.observeText((Control)this.txtIdentificacion, (int[])new int[]{24, 16});
        IObservableValue identificacionModeloDatosObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"identificacion");
        bindingContext.bindValue((IObservableValue)observeTextTxtIdentificacionObserveWidget, identificacionModeloDatosObserveValue, null, null);
        ISWTObservableValue buttonObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.button);
        IObservableValue modeloDatosParteRelacionadaObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"parteRelacionada");
        bindingContext.bindValue((IObservableValue)buttonObserveSelectionObserveWidget, modeloDatosParteRelacionadaObserveValue, null, null);
        ISWTObservableValue button_1ObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.button_1);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)button_1ObserveSelectionObserveWidget, modeloDatosParteRelacionadaObserveValue, strategy, strategy_1);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoCliente.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvTipoCliente.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList modeloClienteClasesDeContribuyenteObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloCliente, (String)"clasesDeContribuyente");
        this.cvTipoCliente.setInput((Object)modeloClienteClasesDeContribuyenteObserveList);
        ISWTObservableValue txtRazonSocialObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRazonSocial, (int)24);
        IObservableValue modeloDatosRazonSocialObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"razonSocial");
        bindingContext.bindValue((IObservableValue)txtRazonSocialObserveTextObserveWidget, modeloDatosRazonSocialObserveValue, null, null);
        return bindingContext;
    }
}

